Config = {}

-------------------
--MZ-STOREROBBERY--
-------------------

Config.UseGabz = false                          -- Change to true to use the following gabz map configurations (PLEASE NOTE NO SUPPORT IS OFFERED FOR 
                                                -- THESE MAP CHANGES. THESE COORDINATES HAVE BEEN GENERATED BY THE COMMUNITY - SEE END OF CONFIG FOR COORDS)

Config.NotifyType = 'qb'                       -- Notification type (set to 'qbcore' to use qb-core standard notifications.)

Config.Drawtext = false                         -- Change to true to re-engage range check drawtext (Consumes more server resources with while loops)

Config.psdispatch = true                        -- set to "false" if you are not using ps-dispatch alerts (if "false", base qb-core alerts will trigger).

Config.DispatchRegisterDelay = 60               -- Time (in seconds) between dispatch pings being sent when lockpicking registers

----------------------
--SERVER PARTICULARS--
----------------------

Config.StressEnabled = true                     -- Change to false to disable accumulation of stress.
Config.PrintChanceRegister = 100                 -- Chance (in percentage) to leave fingerprints if not wearing gloves when robbing a register.
Config.PrintChanceSafe = 100                     -- Chance (in percentage) to leave fingerprints if not wearing gloves when robbing a safe.
Config.resetTime = 60 * 1000 * 15            -- Changing the last number will change the number of minutes for the robbery to reset (for each register)
Config.tickInterval = 1000                      -- No need to change this. 

--------------------
--POLICE VARIABLES--
--------------------
Config.UsePoliceName = true                    -- If this is set to "false", server will check for jobname: "police", otherwise it will check for job type for newer qb-core builds
Config.PoliceJobType = "leo"                    -- Name of job type used by your server - NOTE: Only used if "Config.UsePoliceName = false"
Config.PoliceJobName = "police"                 -- Name of police role in your server - NOTE: Only used if "Config.UsePoliceName = true"

Config.MinimumStoreRobberyPolice = 2            -- Minimum police that need to be on duty before a store can be robbed.

Config.PoliceMinutesCooldown = 5                -- Change minutes to change alert time for police 

-------------
--MZ-SKILLS--
-------------

Config.mzskills = flase                          -- Set to 'false' if you do not wish to use this resource with mz-skills

--if "Config.mzskills = true", then the following parameters apply:

-- "HACKING"

Config.HackXPSkill = "Hacking"                  -- Rename as you wish but make sure you rename it to a skill at mz-skills/config.lua

-- XP Requirements
Config.HackXPlvl8 = 12800
Config.HackXPlvl7 = 6400
Config.HackXPlvl6 = 3200
Config.HackXPlvl5 = 1600
Config.HackXPlvl4 = 800
Config.HackXPlvl3 = 400
Config.HackXPlvl2 = 200
Config.HackXPlvl1 = 100
Config.HackXPlvl0 = 0

-- XP Modifiers
Config.HackingXPLow = 8                         -- Lowest amount of "Hacking" XP added upon successful hack.
Config.HackingXPMid = 11                        -- Mid level "Hacking" XP added upon successful hack.
Config.HackingXPHigh = 14                       -- Highest amount of "Hacking" XP added upon successful hack.
Config.HackingXPLoss = 10                       -- "Hacking" XP lost for failing any hack.

-- "HEIST REPUTATION"

Config.CriminalXPSkill = "Heist Reputation"

-- XP Modifiers (Registers)
Config.HeistXPlow2 = 2                           -- Lowest amount of "Heist Reputation" XP added upon successful hack.
Config.HeistXPmid2 = 3                           -- Mid level "Heist Reputation" XP added upon successful hack.
Config.HeistXPhigh2 = 4                          -- Highest amount of "Heist Reputation" XP added upon successful hack.

-- XP Modifiers (SAFES)
Config.HeistXPlow = 4                           -- Lowest amount of "Heist Reputation" XP added upon successful hack.
Config.HeistXPmid = 6                           -- Mid level "Heist Reputation" XP added upon successful hack.
Config.HeistXPhigh = 8                          -- Highest amount of "Heist Reputation" XP added upon successful hack.

------------------
--CASH REGISTERS--
------------------

-- Lockpick break chances
Config.LockpickBreakChance = 40                 -- Percentage chance of lockpick breaking upon player failing to lockpick cash register.
Config.AdvancedBreakChance = 20                 -- Percentage chance of advanced lockpick breaking upon player failing to lockpick cash register.

-- Mini-game to steal from till
Config.BreakRegister = "circle"                 -- PLEASE DO NOT CHANGE THIS "STANDARD" IS NO LONGER SUPPORTED
-- if "Config.BreakRegister" = "circle", then the following parameters apply:  
Config.circleparses = 4                         -- number of circle parses a player will need to complete
Config.circletime = 13                          -- time for player to complete one parse of the circle

-- Reward type:
Config.CashRegisterReturn = "dirtymoney"        -- Set to "dirtymoney", "markedbills" or "cash" to alter the reward given.
Config.minRegisterEarn = 400                   -- Minimum amount earnt from stealing from a cash register
Config.maxRegisterEarn = 800                   -- Maximum amount earnt from stealing from a cash register

Config.RegisterTime = 10                        -- progressBar time it takes for player to rob cash register after lockpicking (in seconds)

--Chance to drop item to get into liquor store robbery

Config.LiquorItem = "liquorkey"

Config.liquorKey = 0                          -- Percentage chance to find a "liquorkey" from a cash register

Config.liquorKeySafe = 0                    -- Percentage chance to find a "liquorkey" from a convenience store safe.

------------------------------------------------------
--CONVENIENCE STORE/LIQUOR STORE ROBBERY PARTICULARS--
------------------------------------------------------

-------------
--HACK TYPE-- 
-------------

-- Choose the type of hack for convenience store and liquor store safes. They can be different hacks: 
-- Please make sure you set one of the following:'varHack', 'maze', 'mHacking', 'scrambler' 
-- Each hack is configured to work with or without mz-skills. 
-- Please note, all hacks except "mHacking" depend on ps-ui. "mHacking" depends on mhacking. Ensure those resources are up to date. 
-- Please also note, the follow parameters can only be set once. There is no separate way to re-configure the hack for different robberies.

Config.Hacktype = "mHacking"

Config.HacktypeLiquor = "scrambler"

-----------------------
--mHacking PARAMETERS--
-----------------------

-- If "Config.mzskills = true", then the following apply:

-- Level 8
Config.mhacklvl8high = 6
Config.mhacklvl8low = 5
Config.mhacklvl8time = 18
-- Level 7
Config.mhacklvl7high = 5
Config.mhacklvl7low = 5
Config.mhacklvl7time = 17
-- Level 6
Config.mhacklvl6high = 5
Config.mhacklvl6low = 4
Config.mhacklvl6time = 16
-- Level 5
Config.mhacklvl5high = 4
Config.mhacklvl5low = 4
Config.mhacklvl5time = 16
-- Level 4
Config.mhacklvl4high = 4
Config.mhacklvl4low = 3
Config.mhacklvl4time = 15
-- Level 3
Config.mhacklvl3high = 3
Config.mhacklvl3low = 3
Config.mhacklvl3time = 15
-- Level 2
Config.mhacklvl2high = 3
Config.mhacklvl2low = 2
Config.mhacklvl2time = 15
-- Level 1
Config.mhacklvl1high = 3
Config.mhacklvl1low = 2
Config.mhacklvl1time = 14
-- Level 0
Config.mhacklvl0high = 3
Config.mhacklvl0low = 2
Config.mhacklvl0time = 13

-- If "Config.mzskills = false", then the following apply:

Config.mhacklvlNOXPhigh = 4
Config.mhacklvlNOXPlow = 3
Config.mhacklvlNOXPtime = 30

----------------------
--VarHack PARAMETERS--
----------------------

-- If "Config.mzskills = true", then the following apply:

-- Level 8 
Config.varhacklvl8blocks = 2
Config.varhacklvl8time = 12
-- Level 7
Config.varhacklvl7blocks = 3
Config.varhacklvl7time = 12
-- Level 6 
Config.varhacklvl6blocks = 3
Config.varhacklvl6time = 10
-- Level 5
Config.varhacklvl5blocks = 4
Config.varhacklvl5time = 12
-- Level 4 
Config.varhacklvl4blocks = 4
Config.varhacklvl4time = 10
-- Level 3
Config.varhacklvl3blocks = 5
Config.varhacklvl3time = 14
-- Level 2 
Config.varhacklvl2blocks = 5
Config.varhacklvl2time = 12
-- Level 1
Config.varhacklvl1blocks = 5
Config.varhacklvl1time = 10
-- Level 0
Config.varhacklvl0blocks = 6
Config.varhacklvl0time = 12

-- If "Config.mzskills = false", then the following apply:

Config.varhacklvlNOXPblocks = 5
Config.varhacklvlNOXPtime = 12

-------------------
--Maze PARAMETERS--
-------------------

-- If "Config.mzskills = true", then the following apply:

-- Level 8
Config.Maze8Time = 20
-- Level 7
Config.Maze7Time = 18
-- Level 6
Config.Maze6Time = 16
-- Level 5
Config.Maze5Time = 15
-- Level 4
Config.Maze4Time = 14
-- Level 3
Config.Maze3Time = 13
-- Level 2
Config.Maze2Time = 12
-- Level 1
Config.Maze1Time = 11
-- Level 0
Config.Maze0Time = 10

-- If "Config.mzskills = false", then the following apply:

Config.MazeNOXPTime = 15

------------------------
--scrambler PARAMETERS--
------------------------

-- PLEASE NOTE: The acceptable inputs for the following variables are as follows:
-- Type: alphabet, numeric, alphanumeric, greek, braille, runes
-- Time: Any number of seconds (in whole numbers)
-- Mod: 0: Normal, 1: Normal + Mirrored 2: Mirrored only

-- If "Config.mzskills = true", then the following apply:

-- Level 8
Config.ScramLvl8Type = "numeric"
Config.ScramLvl8Time = 18
Config.ScramLvl8Mod = 0
-- Level 7
Config.ScramLvl7Type = "alphabet"
Config.ScramLvl7Time = 17
Config.ScramLvl7Mod = 0
-- Level 6
Config.ScramLvl6Type = "alphanumeric"
Config.ScramLvl6Time = 16
Config.ScramLvl6Mod = 0
-- Level 5
Config.ScramLvl5Type = "greek"
Config.ScramLvl5Time = 15
Config.ScramLvl5Mod = 1
-- Level 4
Config.ScramLvl4Type = "numeric"
Config.ScramLvl4Time = 15
Config.ScramLvl4Mod = 1
-- Level 3
Config.ScramLvl3Type = "alphabet"
Config.ScramLvl3Time = 14
Config.ScramLvl3Mod = 1
-- Level 2
Config.ScramLvl2Type = "alphanumeric"
Config.ScramLvl2Time = 14
Config.ScramLvl2Mod = 2
-- Level 1
Config.ScramLvl1Type = "greek"
Config.ScramLvl1Time = 12
Config.ScramLvl1Mod = 1
-- Level 0
Config.ScramLvl0Type = "alphabet"
Config.ScramLvl0Time = 12
Config.ScramLvl0Mod = 2

-- If "Config.mzskills = false", then the following apply:
Config.ScramNOXPType = "alphanumeric"
Config.ScramNOXPTime = 12
Config.ScramNOXPMod = 2

------------------------------
--SAFE OUTPUTS & PARTICUALRS--
------------------------------

Config.SafeTimelow = 10                         -- Lowest time (in seconds) that it will take a player to raid the safe.
Config.SafeTimehigh = 20                        -- Highest time (in seconds) that it will take a player to raid the safe.

Config.SafeResetTime = 60 * 1000 * 15           -- The first number is the time, in minutes, for a safe to cooldown automatically. 

Config.StressForFailing = 10                    -- Amount of stress a player incurs for failing to breach a safe

----------------------------
--SAFE (CONVENIENCE STORE)--
----------------------------

Config.SafeReqItem = "usb2"                     -- Change to any item you want (needs to be in qb-core/shared/items.lua)

Config.SafeReturn = "markedbills"                -- Set to "dirtymoney", "markedbills" or "cash" to alter the reward given.

Config.minSafeEarn = 400                       -- Minimum amount earnt from stealing from a safe (in dirtymoney)
Config.maxSafeEarn = 800                      -- Maximum amount earnt from stealing from a safe (in dirtymoney)

--RARE DROPS (In addition to money)

Config.RareItemDrops = true                     -- Change to false if you do not want to have the following rare item drops
-- if "Config.RareItemDrops = true", then the following parameters apply: 
--Rare item 1
Config.RareItem1 = "weaponcard"                      -- Name of the rare item that will drop
Config.RareItem1Chance = 100                     -- Percentage chance to obtain the rare item drop from robbing a safe.
Config.RareItemAmount = 1                      -- Amount of the rare item player will receive if chance is triggered
--Rare item 2 (Note: chance for drop is independent for each rare item listed)
Config.RareItem2 = "security_card_02"                    -- Name of the rare item that will drop
Config.RareItem2Chance = 10                     -- Percentage chance to obtain the rare item drop from robbing a safe.
Config.RareItem2Amount = 1                      -- Amount of the rare item player will receive if chance is triggered
--Rare item 3 (Note: chance for drop is independent for each rare item listed)
Config.RareItem3 = "usb2"              -- Name of the rare item that will drop
Config.RareItem3Chance = 2                      -- Percentage chance to obtain the rare item drop from robbing a safe.
Config.RareItem3Amount = 1                      -- Amount of the rare item player will receive if chance is triggered

------------------------
--SAFE (ALCOHOL STORE)--
------------------------

Config.LiquorReqItem = "liquorkey"              -- Item needed to attempt to breach a liquor safe.

Config.AlcoholReturn = "dirtymoney"             -- Set to "dirtymoney", "markedbills" or "cash" to alter the reward given.

Config.AlcoholminSafeEarn = 9000                -- Minimum amount earnt from stealing from a safe (in dirtymoney)
Config.AlcoholmaxSafeEarn = 27000               -- Maximum amount earnt from stealing from a safe (in dirtymoney)
Config.AlcoholSafeTime = 25                     -- Time it takes for player to rob safe (in seconds)
Config.AlcoholStressForFailing = 10             -- Amount of stress a player incurs for failing to breach a safe

--RARE DROPS (In addition to money)

Config.AlcoholRareItemDrops = true              -- Change to false if you do not want to have the following rare item drops
-- if "Config.AlcoholRareItemDrops = true", then the following parameters apply: 
--Rare item 1
Config.AlcoholRareItem1 = "rolex"               -- Name of the rare item that will drop
Config.AlcoholRareItem1Chance = 20              -- Percentage chance to obtain the rare item drop from robbing a safe.
Config.AlcoholRareItemAmount = 2                -- Amount of the rare item player will receive if chance is triggered
--Rare item 2 (Note: chance for drop is independent for each rare item listed)
Config.AlcoholRareItem2 = "goldbar"             -- Name of the rare item that will drop
Config.AlcoholRareItem2Chance = 10              -- Percentage chance to obtain the rare item drop from robbing a safe.
Config.AlcoholRareItem2Amount = 1               -- Amount of the rare item player will receive if chance is triggered
--Rare item 3 (Note: chance for drop is independent for each rare item listed)
Config.AlcoholRareItem3 = "weapon_pistol"       -- Name of the rare item that will drop
Config.AlcoholRareItem3Chance = 2               -- Percentage chance to obtain the rare item drop from robbing a safe.
Config.AlcoholRareItem3Amount = 1               -- Amount of the rare item player will receive if chance is triggered

----------------------
--LIQUOR STORE DOORS--
----------------------

--Doors
Config.UnlockParses = 3                             -- Number of parses of qb-lock when unlocking a liquor store door
Config.UnlockParseTime = 11                         -- Time given per pass, the lower, the more difficult (below 10 is very quick)
Config.BreakChance = 50                             -- Percentage chance to break liquorkey upon failing skill check
Config.TripLocksLow = 4                             -- Lowest number of seconds to trip locks at the end of the robbery
Config.TripLocksHigh = 8                            -- Highest number of seconds to trip locks at the end of the robbery

-- Please make sure you add the "Liquorstore" doorlock config to your doorlock resource or these doors will be open by default 
-- and the functions to open the doors will be meaningless. (You are welcome to run the script without locking the liquor doors)

-- No need to change these door names. 
Config.LiquorOuter1 = 'Liquorstore-door1-outer'
Config.LiquorInner1 = 'Liquorstore-door1-inner'
Config.LiquorOuter2 = 'Liquorstore-door2-outer'
Config.LiquorInner2 = 'Liquorstore-door2-inner'
Config.LiquorOuter3 = 'Liquorstore-door3-outer'
Config.LiquorInner3 = 'Liquorstore-door3-inner'
Config.LiquorOuter4 = 'Liquorstore-door4-outer'
Config.LiquorInner4 = 'Liquorstore-door4-inner'
Config.LiquorOuter5 = 'Liquorstore-door5-outer'
Config.LiquorInner5 = 'Liquorstore-door5-inner'

-------------------------
--VECTOR CONFIGURATIONS--
-------------------------


Config.RegistersTarget = {
    [1] = {
        ["coords"] = vector3(288.46, 273.05, 14.76),  
        robbed = false, 
        time = 0, 
        safeKey = 1,
        camId = 4,
    },
    [2] = {
        ["coords"] = vector3(288.41, 274.95, 14.76), 
        robbed = false, 
        time = 0, 
        safeKey = 1,
        camId = 4,
    },
    [3] = {
        ["coords"] = vector3(-104.24, 652.7, 14.81),  
        robbed = false, 
        time = 0, 
        safeKey = 2,
        camId = 5,
    },
    [4] = {
        ["coords"] = vector3(-102.29, 652.73, 14.81), 
        robbed = false, 
        time = 0, 
        safeKey = 3,
        camId = 6,
    },
    [5] = {
        ["coords"] = vector3(1132.97, -46.8, 14.36), 
        robbed = false, 
        time = 0, 
        safeKey = 4,
        camId = 7,
    },
    [6] = {
        ["coords"] = vector3(1130.97, -46.84, 14.36), 
        robbed = false, 
        time = 0, 
        safeKey = 4,
        camId = 7,
    },
    [7] = {
        ["coords"] = vector3(771.19, 2236.16, 32.7), 
        robbed = false, 
        time = 0, 
        safeKey = 5,
        camId = 8,
    },
    [8] = {
        ["coords"] = vector3(769.19, 2236.21, 32.7), 
        robbed = false, 
        time = 0, 
        safeKey = 5,
        camId = 8,
    },
}

Config.SafesTarget = {
    [1] = {
        ["coords"] = vector3(284.75, 284.28, 14.76), 
        type = "keypad",
        robbed = false, 
        camId = 4
    },
    [2] = {
        ["coords"] = vector3(-92.97, 656.34, 14.81), 
        type = "keypad",
        robbed = false, 
        camId = 5
    },
    [3] = {
        ["coords"] = vector3(1121.75, -50.52, 14.36), 
        type = "keypad",
        robbed = false, 
        camId = 6
    },
    [4] = {
        ["coords"] = vector3(759.86, 2232.53, 32.7), 
        type = "keypad",
        robbed = false, 
        camId = 7
    },
}

-----------------------
--GABZ CONFIGURATIONS--
-----------------------

Config.RegistersTargetGabz = {
    [1] = {
        ["coords"] = vector3(-47.24, -1757.65, 29.53), 
        robbed = false, 
        time = 0, 
        safeKey = 1,
        camId = 4,
    },
    [2] = {
        ["coords"] = vector3(-48.58, -1759.21, 29.59), 
        robbed = false, 
        time = 0, 
        safeKey = 1,
        camId = 4,
    },
    [3] = {
        ["coords"] = vector3(-1486.67, -378.46, 40.27), 
        robbed = false, 
        time = 0, 
        safeKey = 2,
        camId = 5,
    },
    [4] = {
        ["coords"] = vector3(-1222.33, -907.82, 12.43), 
        robbed = false, 
        time = 0, 
        safeKey = 3,
        camId = 6,
    },
    [5] = {
        ["coords"] = vector3(-706.08, -915.42, 19.21), 
        robbed = false, 
        time = 0, 
        safeKey = 4,
        camId = 7,
    },
    [6] = {
        ["coords"] = vector3(-706.16, -913.5, 19.21), 
        robbed = false, 
        time = 0, 
        safeKey = 4,
        camId = 7,
    },
    [7] = {
        ["coords"] = vector3(25.44, -1345.7, 29.68), 
        robbed = false, 
        time = 0, 
        safeKey = 5,
        camId = 8,
    },
    [8] = {
        ["coords"] = vector3(25.46, -1347.86, 29.68), 
        robbed = false, 
        time = 0, 
        safeKey = 5,
        camId = 8,
    },
    [9] = {
        ["coords"] = vector3(1134.15, -982.53, 46.41), 
        robbed = false, 
        time = 0, 
        safeKey = 6,
        camId = 9,
    },
    [10] = {
        ["coords"] = vector3(1165.05, -324.49, 69.2), 
        robbed = false, 
        time = 0, 
        safeKey = 7,
        camId = 10,
    },
    [11] = {
        ["coords"] = vector3(1164.7, -322.58, 69.2), 
        robbed = false, 
        time = 0, 
        safeKey = 7,
        camId = 10,
    },
    [12] = {
        ["coords"] = vector3(373.89, 327.74, 103.75), 
        robbed = false, 
        time = 0, 
        safeKey = 8,
        camId = 11,
    },
    [13] = {
        ["coords"] = vector3(373.39, 325.64, 103.75), 
        robbed = false, 
        time = 0, 
        safeKey = 8,
        camId = 11,
    },
    [14] = {
        ["coords"] = vector3(-1818.9, 792.9, 138.08), 
        robbed = false, 
        time = 0, 
        safeKey = 9,
        camId = 12,
    },
    [15] = {
        ["coords"] = vector3(-1820.17, 794.28, 138.08), 
        robbed = false, 
        time = 0, 
        safeKey = 9,
        camId = 12,
    },
    [16] = {
        ["coords"] = vector3(-2966.46, 390.89, 15.04), 
        robbed = false, 
        time = 0, 
        safeKey = 10,
        camId = 13,
    },
    [17] = {
        ["coords"] = vector3(-3040.79, 584.96, 8.09), 
        robbed = false, 
        time = 0, 
        safeKey = 11,
        camId = 14,
    },
    [18] = {
        ["coords"] = vector3(-3038.75, 585.65, 8.09), 
        robbed = false, 
        time = 0, 
        safeKey = 11,
        camId = 14,
    },
    [19] = {
        ["coords"] = vector3(-3243.78, 1001.08, 13.02), 
        robbed = false, 
        time = 0, 
        safeKey = 12,
        camId = 15,
    },
    [20] = {
        ["coords"] = vector3(-3241.63, 1000.92, 13.02), 
        robbed = false, 
        time = 0, 
        safeKey = 12,
        camId = 15,
    },
    [21] = {
        ["coords"] = vector3(548.32, 2669.62, 42.34), 
        robbed = false, 
        time = 0, 
        safeKey = 13,
        camId = 16,
    },
    [22] = {
        ["coords"] = vector3(548.01, 2671.76, 42.34), 
        robbed = false, 
        time = 0, 
        safeKey = 13,
        camId = 16,
    },
    [23] = {
        ["coords"] = vector3(1165.9, 2710.81, 38.15), 
        robbed = false, 
        time = 0, 
        safeKey = 14,
        camId = 17,
    },
    [24] = {
        ["coords"] = vector3(2677.1, 3281.03, 55.43), 
        robbed = false, 
        time = 0, 
        safeKey = 15,
        camId = 18,
    },
    [25] = {
        ["coords"] = vector3(2679.0, 3280.01, 55.43), 
        robbed = false, 
        time = 0, 
        safeKey = 15,
        camId = 18,
    },
    [26] = {
        ["coords"] = vector3(1960.12, 3741.89, 32.53), 
        robbed = false, 
        time = 0, 
        safeKey = 16,
        camId = 19,
    },
    [27] = {
        ["coords"] = vector3(1961.22, 3740.03, 32.53), 
        robbed = false, 
        time = 0, 
        safeKey = 16,
        camId = 19,
    },
    [28] = {
        ["coords"] = vector3(1729.44, 6416.23, 35.22), 
        robbed = false, 
        time = 0, 
        safeKey = 17,
        camId = 20,
    },
    [29] = {
        ["coords"] = vector3(1728.5, 6414.29, 35.22), 
        robbed = false, 
        time = 0, 
        safeKey = 17,
        camId = 20,
    },
    [30] = {
        ["coords"] = vector3(162.34, 6642.07, 31.88), 
        robbed = false, 
        time = 0, 
        safeKey = 18,
        camId = 27,
    },
    [31] = {
        ["coords"] = vector3(160.83, 6640.52, 31.88), 
        robbed = false, 
        time = 0, 
        safeKey = 19,
        camId = 28,
    },
    [32] = {
        ["coords"] = vector3(0, 0, 0), 
        robbed = false, 
        time = 0, 
        safeKey = 19,
        camId = 29,
    },
}

Config.SafesTargetGabz = {
    [1] = {
        ["coords"] = vector3(-43.43, -1748.3, 29.42), 
        type = "keypad",
        robbed = false, 
        camId = 4
    },
    [2] = {
        ["coords"] = vector3(-1478.94, -375.5, 39.16), 
        type = "padlock",
        robbed = false, 
        camId = 5
    },
    [3] = {
        ["coords"] = vector3(-1220.85, -916.05, 11.32), 
        type = "padlock",
        robbed = false, 
        camId = 6
    },
    [4] = {
        ["coords"] = vector3(-709.74, -904.15, 19.21), 
        type = "keypad",
        robbed = false, 
        camId = 7
    },
    [5] = {
        ["coords"] = vector3(31.29, -1339.17, 29.5), 
        type = "keypad",
        robbed = false, 
        camId = 8
    },
    [6] = {
        ["coords"] = vector3(1126.77, -980.1, 45.41), 
        type = "padlock",
        robbed = false, 
        camId = 9
    },
    [7] = {
        ["coords"] = vector3(1159.46, -314.05, 69.2), 
        type = "keypad",
        robbed = false, 
        camId = 10
    },
    [8] = {
        ["coords"] = vector3(381.13, 332.56, 103.57), 
        type = "keypad",
        robbed = false, 
        camId = 11
    },
    [9] = {
        ["coords"] = vector3(-1829.27, 798.76, 138.19), 
        type = "keypad",
        robbed = false, 
        camId = 12
    },
    [10] = {
        ["coords"] = vector3(-2959.64, 387.08, 14.04), 
        type = "padlock",
        robbed = false, 
        camId = 13
    },
    [11] = {
        ["coords"] = vector3(-3048.71, 588.47, 7.91), 
        type = "keypad",
        robbed = false, 
        camId = 14
    },
    [12] = {
        ["coords"] = vector3(-3249.76, 1007.37, 12.83), 
        type = "keypad",
        robbed = false, 
        camId = 15
    },
    [13] = {
        ["coords"] = vector3(543.78, 2662.55, 42.16), 
        type = "keypad",
        robbed = false, 
        camId = 16
    },
    [14] = {
        ["coords"] = vector3(1169.31, 2717.79, 37.15), 
        type = "padlock",
        robbed = false, 
        camId = 17
    },
    [15] = {
        ["coords"] = vector3(2674.27, 3289.31, 55.24), 
        type = "keypad",
        robbed = false, 
        camId = 18
    },
    [16] = {
        ["coords"] = vector3(1961.74, 3750.31, 32.34), 
        type = "keypad",
        robbed = false, 
        camId = 19
    },
    [17] = {
        ["coords"] = vector3(1737.48, 6419.5, 35.04), 
        type = "keypad",
        robbed = false, 
        camId = 20
    },
    [18] = {
        ["coords"] = vector3(-168.40, 6318.80, 30.58), 
        type = "padlock",
        robbed = false, 
        camId = 27
    },
    [19] = {
        ["coords"] = vector3(171.03, 6642.62, 31.7), 
        type = "keypad",
        robbed = false, 
        camId = 30
    },
}


Config.MaleNoHandshoes = {
    [0] = true, [1] = true, [2] = true, [3] = true, [4] = true, [5] = true, [6] = true, [7] = true, [8] = true, [9] = true, [10] = true, [11] = true, [12] = true, [13] = true, [14] = true, [15] = true, [18] = true, [26] = true, [52] = true, [53] = true, [54] = true, [55] = true, [56] = true, [57] = true, [58] = true, [59] = true, [60] = true, [61] = true, [62] = true, [112] = true, [113] = true, [114] = true, [118] = true, [125] = true, [132] = true,
}
Config.FemaleNoHandshoes = {
    [0] = true, [1] = true, [2] = true, [3] = true, [4] = true, [5] = true, [6] = true, [7] = true, [8] = true, [9] = true, [10] = true, [11] = true, [12] = true, [13] = true, [14] = true, [15] = true, [19] = true, [59] = true, [60] = true, [61] = true, [62] = true, [63] = true, [64] = true, [65] = true, [66] = true, [67] = true, [68] = true, [69] = true, [70] = true, [71] = true, [129] = true, [130] = true, [131] = true, [135] = true, [142] = true, [149] = true, [153] = true, [157] = true, [161] = true, [165] = true,
}
